# medi8 Architecture Overview

## System Architecture (Milestone 2)

```
┌─────────────────────────────────────────────────────────────────┐
│                         PRESENTATION LAYER                       │
│                        (Next.js App Router)                      │
├─────────────────────────────────────────────────────────────────┤
│                                                                   │
│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐         │
│  │   PUBLIC     │  │   MEDIATOR   │  │    ADMIN     │         │
│  │              │  │              │  │              │         │
│  │ /practices   │  │ /mediator/*  │  │ /admin/*     │         │
│  │ /login       │  │              │  │              │         │
│  │ /register    │  │              │  │              │         │
│  └──────────────┘  └──────────────┘  └──────────────┘         │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
                              ↓
┌─────────────────────────────────────────────────────────────────┐
│                        MIDDLEWARE LAYER                          │
│                     (Route Protection)                           │
├─────────────────────────────────────────────────────────────────┤
│                                                                   │
│  • Session Validation                                            │
│  • Role-Based Access Control                                     │
│  • Public Route Handling                                         │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
                              ↓
┌─────────────────────────────────────────────────────────────────┐
│                         BUSINESS LOGIC                           │
│                      (Domain Modules)                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                   │
│  ┌────────────────┐  ┌─────────────────┐  ┌──────────────┐    │
│  │     Auth       │  │    Mediator     │  │    Admin     │    │
│  │                │  │                 │  │              │    │
│  │ • Login        │  │ • Profile       │  │ • Approvals  │    │
│  │ • Register     │  │ • Pricing       │  │ • Audit      │    │
│  │ • Session      │  │ • Status        │  │ • Config     │    │
│  └────────────────┘  └─────────────────┘  └──────────────┘    │
│                                                                   │
│  ┌────────────────┐  ┌─────────────────┐  ┌──────────────┐    │
│  │   Notification │  │    Storage      │  │   Email      │    │
│  │                │  │                 │  │              │    │
│  │ • Templates    │  │ • Local/S3      │  │ • Console    │    │
│  │ • Logging      │  │ • Abstraction   │  │ • SendGrid   │    │
│  └────────────────┘  └─────────────────┘  └──────────────┘    │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
                              ↓
┌─────────────────────────────────────────────────────────────────┐
│                          DATA LAYER                              │
│                     (Prisma ORM + PostgreSQL)                    │
├─────────────────────────────────────────────────────────────────┤
│                                                                   │
│  24 Tables:                                                      │
│  • User, Session                                                 │
│  • Mediator, MediatorPricing, SubscriptionInvoice              │
│  • Client                                                        │
│  • Case, CaseParty, CaseTimeline                                │
│  • Document                                                      │
│  • Payment, Payout                                               │
│  • NotificationTemplate, NotificationLog                         │
│  • AuditLog, PlatformConfig                                      │
│  • IntegrationConfig, WebhookEvent                              │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
```

## Data Flow: Profile Editing

```
┌──────────────┐
│   Mediator   │
│   Browser    │
└──────┬───────┘
       │ 1. Edit Profile Form
       ↓
┌──────────────────────┐
│  ProfileForm.tsx     │
│  (Client Component)  │
└──────┬───────────────┘
       │ 2. form.action()
       ↓
┌──────────────────────────────┐
│  updateProfileAction()       │
│  (Server Action)             │
└──────┬───────────────────────┘
       │ 3. Validate with Zod
       ↓
┌──────────────────────────────┐
│  MediatorProfileService      │
│  updateProfile()             │
└──────┬───────────────────────┘
       │ 4. Check ownership
       │ 5. Update database
       ↓
┌──────────────────────────────┐
│  Prisma ORM                  │
│  prisma.mediator.update()    │
└──────┬───────────────────────┘
       │ 6. PostgreSQL write
       ↓
┌──────────────────────────────┐
│  PostgreSQL Database         │
└──────┬───────────────────────┘
       │ 7. Return updated data
       ↓
┌──────────────────────────────┐
│  createAuditLog()            │
│  Log the change              │
└──────┬───────────────────────┘
       │ 8. revalidatePath()
       ↓
┌──────────────────────────────┐
│  Next.js Cache               │
│  Invalidate & Refresh        │
└──────┬───────────────────────┘
       │ 9. Return success
       ↓
┌──────────────────────────────┐
│  ProfileForm.tsx             │
│  Show success message        │
└──────────────────────────────┘
```

## Data Flow: Admin Approval

```
┌──────────────┐
│    Admin     │
│   Browser    │
└──────┬───────┘
       │ 1. Click "Approve"
       ↓
┌──────────────────────────────┐
│  ApprovalCard.tsx            │
│  (Client Component)          │
└──────┬───────────────────────┘
       │ 2. approveMediatorAction()
       ↓
┌──────────────────────────────┐
│  Server Action               │
│  Check ADMIN role            │
└──────┬───────────────────────┘
       │ 3. Verify authorization
       ↓
┌──────────────────────────────┐
│  MediatorProfileService      │
│  approveMediator()           │
└──────┬───────────────────────┘
       │ 4. Update status to APPROVED
       │ 5. Add approval notes
       │ 6. Set approvedAt date
       ↓
┌──────────────────────────────┐
│  Prisma ORM                  │
│  Update mediator record      │
└──────┬───────────────────────┘
       │ 7. Database write
       ↓
┌──────────────────────────────┐
│  createAuditLog()            │
│  MEDIATOR_APPROVE action     │
└──────┬───────────────────────┘
       │ 8. Log to audit table
       ↓
┌──────────────────────────────┐
│  sendEmail()                 │
│  MEDIATOR_APPROVED template  │
└──────┬───────────────────────┘
       │ 9. Send notification
       ↓
┌──────────────────────────────┐
│  NotificationLog             │
│  Track email sent            │
└──────┬───────────────────────┘
       │ 10. Return success
       ↓
┌──────────────────────────────┐
│  ApprovalCard.tsx            │
│  Update UI                   │
└──────────────────────────────┘
```

## Status Workflow

```
┌─────────────────────┐
│   REGISTRATION      │
│   (New Mediator)    │
└──────────┬──────────┘
           ↓
┌─────────────────────┐
│ PENDING_APPROVAL    │
│                     │
│ • Profile complete  │
│ • Waiting review    │
└──────┬──────────────┘
       │
       │ Admin Reviews
       │
       ↓
┌──────────────────────────────┐
│         DECISION              │
└──────┬───────────────┬────────┘
       │               │
    APPROVE         REJECT
       │               │
       ↓               ↓
┌─────────────┐  ┌─────────────┐
│  APPROVED   │  │  REJECTED   │
│             │  │             │
│ Ready to    │  │ Can         │
│ publish     │  │ resubmit    │
└──────┬──────┘  └──────┬──────┘
       │                │
    Admin               │
   Publishes            │
       │                │
       ↓                │
┌─────────────┐         │
│ PUBLISHED   │         │
│             │         │
│ Live on     │◄────────┘
│ /practices  │   Resubmit
└─────────────┘   (back to PENDING)
       │
       │ Admin can
       │ Suspend
       ↓
┌─────────────┐
│ SUSPENDED   │
│             │
│ Hidden from │
│ public      │
└─────────────┘
```

## Security Layers

```
┌─────────────────────────────────────────┐
│          1. NETWORK SECURITY             │
│  • HTTPS (production)                    │
│  • Secure cookies                        │
│  • CSRF protection (SameSite)           │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│       2. AUTHENTICATION LAYER            │
│  • Session-based auth                    │
│  • httpOnly cookies                      │
│  • 7-day expiry                          │
│  • bcrypt password hashing               │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│       3. AUTHORIZATION LAYER             │
│  • Role-based access (ADMIN/MEDIATOR)   │
│  • Middleware route protection           │
│  • Resource ownership checks             │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│        4. DATA VALIDATION                │
│  • Zod schemas                           │
│  • Server-side validation                │
│  • Type safety (TypeScript)              │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│       5. DATABASE SECURITY               │
│  • Prisma ORM (SQL injection prevent)   │
│  • Parameterized queries                 │
│  • Connection pooling                    │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│         6. AUDIT LOGGING                 │
│  • All mutations logged                  │
│  • User ID tracking                      │
│  • Timestamp & metadata                  │
└─────────────────────────────────────────┘
```

## Module Dependencies

```
┌──────────────┐
│     Auth     │  ← Foundation (no dependencies)
└──────┬───────┘
       │
       ↓
┌──────────────────────────────────┐
│  Mediator Profile & Pricing      │  ← Depends on Auth
└──────┬───────────────────────────┘
       │
       ↓
┌──────────────┐
│    Admin     │  ← Depends on Auth + Mediator
└──────┬───────┘
       │
       ↓
┌──────────────┐
│ Notification │  ← Used by all modules
└──────────────┘

Shared Utilities:
• Audit (used by all)
• Errors (used by all)
• Email (used by Notification)
• Storage (used by Documents - M6)
```

## Tech Stack Layers

```
┌─────────────────────────────────────┐
│        FRONTEND                      │
│  • React 18                          │
│  • Next.js 14 App Router            │
│  • TypeScript                        │
│  • Tailwind CSS                      │
│  • Client Components (forms)         │
│  • Server Components (pages)         │
└─────────────────────────────────────┘
                ↓
┌─────────────────────────────────────┐
│        APPLICATION LOGIC             │
│  • Server Actions                    │
│  • API Routes (webhooks)             │
│  • Service Classes                   │
│  • Validation (Zod)                  │
└─────────────────────────────────────┘
                ↓
┌─────────────────────────────────────┐
│        DATABASE LAYER                │
│  • Prisma ORM                        │
│  • PostgreSQL 14+                    │
│  • Migrations                        │
└─────────────────────────────────────┘
                ↓
┌─────────────────────────────────────┐
│     EXTERNAL SERVICES                │
│  • Stripe (M5)                       │
│  • SendGrid (M6)                     │
│  • AWS S3 (M6)                       │
└─────────────────────────────────────┘
```

## File Organization

```
medi8/
│
├── src/
│   ├── app/                    # Next.js App Router
│   │   ├── (admin)/           # Admin routes
│   │   ├── (mediator)/        # Mediator routes
│   │   ├── (client)/          # Client routes
│   │   ├── practices/         # Public routes
│   │   └── api/               # API routes
│   │
│   ├── components/            # React components
│   │   ├── mediator/         # Mediator-specific
│   │   ├── admin/            # Admin-specific
│   │   └── [shared]          # Shared components
│   │
│   ├── modules/              # Business logic
│   │   ├── auth/            # Authentication
│   │   ├── mediator/        # Mediator features
│   │   │   ├── profile/    # Profile management
│   │   │   └── pricing/    # Pricing config
│   │   └── shared/         # Shared utilities
│   │
│   └── lib/                 # Core utilities
│       ├── db.ts           # Prisma client
│       ├── email.ts        # Email abstraction
│       └── storage.ts      # Storage abstraction
│
├── prisma/
│   ├── schema.prisma       # Database schema
│   └── seed.ts            # Seed script
│
└── [config files]         # Next, TS, Tailwind
```

## Deployment Architecture

```
┌─────────────────────────────────────────┐
│           USERS                          │
│  • Mediators                             │
│  • Clients                               │
│  • Public visitors                       │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│           CDN / EDGE                     │
│  • Global distribution                   │
│  • Static assets                         │
│  • Cache                                 │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│      APPLICATION SERVER                  │
│  • Next.js server                        │
│  • Server Actions                        │
│  • API Routes                            │
│  • SSR/SSG                               │
└─────────────┬───────────────────────────┘
              ↓
┌─────────────────────────────────────────┐
│         DATABASE                         │
│  • PostgreSQL                            │
│  • Connection pooling                    │
│  • Backups                               │
└─────────────────────────────────────────┘
```

---

## Key Design Decisions

### 1. Server Actions over API Routes
- Better TypeScript integration
- Progressive enhancement
- Simpler error handling
- Direct database access

### 2. Inline Editing Pattern
- Better UX (edit in place)
- Reduced navigation
- Clearer context
- Optimistic updates

### 3. Status Workflow Separation
- APPROVED ≠ PUBLISHED
- Admin controls publishing
- Safety gate before going live
- Can unpublish if needed

### 4. Service Layer Pattern
- Business logic isolated
- Reusable across actions
- Easier to test
- Clear responsibilities

### 5. Audit Everything
- Compliance ready
- Debugging aid
- User activity tracking
- Admin accountability

---

This architecture supports:
- ✅ Multi-tenancy (strict data isolation)
- ✅ Role-based access
- ✅ Scalability (horizontal scaling ready)
- ✅ Security (multiple layers)
- ✅ Maintainability (clear module boundaries)
- ✅ Extensibility (easy to add features)
