# Changelog

All notable changes to the medi8 project will be documented in this file.

## [Milestone 2] - 2025-01-30

### Added - Profile Management
- Complete mediator profile editing interface
- Inline editing pattern (view → edit → save)
- Profile completeness validation
- Bio field with 50-2000 character validation
- Years of experience field
- Contact information (phone, office address)
- Display name (optional professional title)
- Profile status banner component with contextual messaging

### Added - Specializations
- 12 predefined common specializations (Family, Divorce, Workplace, Commercial, etc.)
- Custom specialization support
- Multi-select interface with checkboxes
- Visual specialization tags on profiles
- Minimum 1 specialization required for submission

### Added - Certifications & Languages
- 8 common certifications (NMAS, FDR, Lawyer, etc.)
- 12 common languages (English, Mandarin, Arabic, etc.)
- Custom entry support for both
- Optional fields (not required for submission)
- List display on public profiles

### Added - Pricing Configuration
- Pre-mediation fee (optional flat fee)
- Hourly rate with two bases:
  - PER_PARTY: Rate multiplied by number of parties
  - TOTAL: Fixed rate regardless of parties
- Minimum hours configuration
- Travel policy:
  - Included kilometers (free travel distance)
  - Per kilometer rate beyond included
- Accommodation policy:
  - Text description field
  - Optional flat rate
- Extra costs notes field
- Quote calculator service with GST awareness
- Separate pricing page at /mediator/profile/pricing

### Added - Status Workflow
- PENDING_APPROVAL state (after registration)
- APPROVED state (after admin approval)
- PUBLISHED state (live on public site)
- REJECTED state (with resubmission capability)
- SUSPENDED state (admin moderation)
- Status transition validation
- Automatic status banners based on current state
- Submit for approval button (when profile complete)
- Resubmit button (when rejected)

### Added - Admin Approval System
- Admin approvals page at /admin/approvals
- Pending mediators queue
- Approval card component with full profile preview
- Approve action with optional notes
- Reject action with required reason
- Publish action for approved profiles
- Suspend action for published profiles
- Real-time status updates
- Email notifications on approve/reject
- Audit logging for all admin actions

### Added - Public Practice Pages
- Public directory at /practices
- Individual practice pages at /practices/[slug]
- Access control (only PUBLISHED mediators visible)
- Professional profile display with:
  - Photo (if provided)
  - Bio and experience
  - Specializations
  - Certifications
  - Languages
  - Complete pricing breakdown
  - Contact CTA
- SEO-friendly slug-based URLs
- 404 for unpublished/non-existent profiles
- Responsive design for mobile

### Added - Email Notifications
- MEDIATOR_APPROVED template (sent on approval)
- MEDIATOR_REJECTED template (sent on rejection with reason)
- Email notification service integration
- Template variable substitution ({{firstName}}, {{slug}}, {{reason}})
- Console logging in development
- Notification log database tracking

### Added - Components
- ProfileStatus.tsx - Status banner with submit actions
- ProfileForm.tsx - Basic information editor
- SpecializationsForm.tsx - Multi-select specializations
- CertificationsForm.tsx - Certifications and languages editor
- PricingForm.tsx - Complete pricing configuration
- ApprovalCard.tsx - Admin approval interface with actions

### Added - Services
- MediatorProfileService - Profile CRUD and status management
  - getProfile() - Fetch by ID
  - getProfileBySlug() - Fetch for public pages
  - updateProfile() - Update fields
  - isProfileComplete() - Check submission readiness
  - submitForApproval() - Change status to pending
  - getAllMediators() - Admin query with filters
  - approveMediator() - Admin approval
  - rejectMediator() - Admin rejection
  - publishMediator() - Make live
  - suspendMediator() - Moderate profile
  - getPublishedMediators() - Public directory query
- PricingService - Pricing management
  - getPricing() - Fetch pricing config
  - upsertPricing() - Create or update pricing
  - calculateQuote() - Generate price quotes with GST

### Added - Server Actions
- updateProfileAction - Update basic profile fields
- updateSpecializationsAction - Update specializations list
- updateCertificationsAction - Update certifications
- updateLanguagesAction - Update languages
- submitForApprovalAction - Submit profile for review
- approveMediatorAction - Admin approve (requires ADMIN role)
- rejectMediatorAction - Admin reject (requires ADMIN role)
- publishMediatorAction - Admin publish (requires ADMIN role)
- suspendMediatorAction - Admin suspend (requires ADMIN role)
- unpublishMediatorAction - Admin unpublish (requires ADMIN role)
- updatePricingAction - Update pricing configuration

### Added - Validation
- Profile validation schemas (Zod)
- Bio: 50-2000 characters
- Phone: required for submission
- Years of experience: 0-70
- Specializations: minimum 1 required
- Pricing validation:
  - Hourly rate: $1-$10,000
  - Travel: 0-1000 km, $0-$100/km
  - Accommodation: $0-$10,000
- Server-side validation on all actions
- Client-side validation in forms

### Added - Access Control
- Profile ownership verification (userId check)
- Admin role verification for admin actions
- Public page access control (PUBLISHED only)
- Audit logging on all mutations
- Session verification on protected routes

### Changed - Mediator Dashboard
- Updated status display with workflow states
- Added profile completeness indicators
- Added quick action cards for profile/pricing
- Added public page link (when published)
- Improved trial status banner
- Added getting started checklist

### Changed - Admin Dashboard
- Updated to show pending approvals count
- Added quick link to approvals page
- Improved statistics display
- Added quick actions section

### Changed - Middleware
- Updated public route handling
- Changed /mediators/* to /practices/* for public pages
- Maintained security on protected routes

### Changed - Navigation
- Added "Profile" link to mediator navigation
- Mediator dashboard now shows profile status
- Admin navigation includes approvals link

### Fixed
- Session persistence across page reloads
- Form state management in client components
- Optimistic UI updates on save
- Error handling and display
- Type safety throughout codebase

### Security
- All profile updates verify user ownership
- Admin actions require ADMIN role
- Audit logs created for all mutations
- No cross-mediator data leakage
- Rejected profiles cannot be published directly
- Suspended profiles removed from public view

### Database
- No schema changes (M1 schema was future-proof!)
- All features use existing tables:
  - Mediator (profile, status, GST info)
  - MediatorPricing (rates, travel, accommodation)
  - AuditLog (all actions tracked)
  - NotificationLog (email tracking)

### Performance
- Server Components by default
- Client Components only where needed (forms)
- Efficient database queries with proper includes
- Revalidate paths after mutations
- Optimistic UI updates

### Documentation
- Added DEPLOYMENT_GUIDE.md (comprehensive deployment)
- Added MILESTONE_2_SUMMARY.md (feature summary)
- Updated README.md (setup instructions)
- Inline code documentation
- JSDoc comments on services

---

## [Milestone 1] - 2025-01-29

### Added - Initial Release
- Next.js 14 App Router setup
- TypeScript configuration
- Tailwind CSS styling
- Prisma ORM with PostgreSQL
- Complete database schema (24 models, 14 enums)
- Authentication system:
  - Session-based auth with secure cookies
  - Role-based access (CLIENT, MEDIATOR, ADMIN)
  - Password hashing with bcrypt
  - Login/logout/register flows
- User registration:
  - Client registration
  - Mediator registration with GST tracking
  - Trial period management
- Admin dashboard with platform stats
- Mediator dashboard with trial tracking
- Client dashboard with getting started guide
- Route protection middleware
- Audit logging system
- Email abstraction (console/SendGrid)
- Storage abstraction (local/S3)
- Platform configuration management
- Notification template system
- Seed script with admin user
- Complete documentation

### Database Schema
- User & Session tables
- Mediator & MediatorPricing tables
- Client table
- Case & CaseParty & CaseTimeline tables
- Document table
- Payment & Payout tables
- SubscriptionInvoice table
- NotificationTemplate & NotificationLog tables
- AuditLog table
- PlatformConfig table
- IntegrationConfig & WebhookEvent tables
- Complete enum definitions

### Security
- HttpOnly cookies
- Secure cookies in production
- CSRF protection (SameSite)
- Role-based access control
- Session expiry (7 days)
- Password hashing (bcrypt, 10 rounds)
- SQL injection prevention (Prisma)

---

## Upcoming

### [Milestone 3] - Public Discovery Enhancement
- Search and filtering
- Mediator categories
- Sort options
- Enhanced directory UI

### [Milestone 4] - Case Management
- Client inquiry system
- Case creation workflow
- Multi-party case support
- Case status tracking
- Timeline management

### [Milestone 5] - Payments
- Stripe Connect integration
- Payment processing
- Platform fee calculation
- Subscription billing
- Webhook handling
- Invoice generation

### [Milestone 6] - Documents & Notifications
- File upload/download
- Document management
- Production email (SendGrid)
- S3 storage integration
- Enhanced admin tools
- Audit log viewer

---

## Version History

- **v0.2.0** - Milestone 2 (Current)
  - Profile management
  - Admin approvals
  - Public practice pages
  - Pricing configuration

- **v0.1.0** - Milestone 1
  - Foundation & authentication
  - Database schema
  - Basic dashboards
  - Admin bootstrap

---

## Breaking Changes

None yet. Schema designed to be forward-compatible.

---

## Migration Notes

### From M1 to M2

No database migrations required! The M1 schema already supported all M2 features.

**Steps to upgrade:**
1. Pull latest code
2. Run `npm install` (no new dependencies)
3. Run `npm run db:generate` (regenerate Prisma client)
4. Restart dev server
5. All existing data preserved

**No data loss, no downtime!**

---

## Contributors

- Claude (Anthropic) - Full-stack development
- Product team - Requirements and specifications

---

## License

Proprietary - All rights reserved
