# Testing Guide for medi8

Complete testing scenarios for Milestone 1 & 2 features.

## Test Environment Setup

### Prerequisites
- Application running locally (`npm run dev`)
- Fresh database with seed data
- Browser with dev tools open
- Incognito/private window for public testing

### Test Accounts

**Admin:**
- Email: `admin@medi8.com.au`
- Password: `admin123`

**Test Mediator** (create during testing):
- Any email
- Any password (min 6 chars)

**Test Client** (create during testing):
- Any email
- Any password (min 6 chars)

---

## Test Suite 1: Authentication & Authorization

### Test 1.1: Admin Login
**Steps:**
1. Navigate to http://localhost:3000/login
2. Enter admin credentials
3. Click "Sign in"

**Expected:**
- ✅ Redirects to /admin/dashboard
- ✅ Shows admin navigation
- ✅ Displays platform statistics
- ✅ Session cookie set (check DevTools → Application → Cookies)

### Test 1.2: Mediator Registration
**Steps:**
1. Navigate to http://localhost:3000/register/mediator
2. Fill in:
   - First name: "John"
   - Last name: "Smith"
   - Email: "john.smith@example.com"
   - Phone: "+61 412 345 678"
   - Password: "password123"
   - Check "I am registered for GST"
   - GST Number: "12 345 678 901"
3. Submit form

**Expected:**
- ✅ Redirects to /mediator/dashboard
- ✅ Shows "Complete Your Profile" banner
- ✅ Status shows "Pending Approval"
- ✅ Trial banner shows 30 days remaining
- ✅ Audit log created (check Prisma Studio)

### Test 1.3: Client Registration
**Steps:**
1. Logout (if logged in)
2. Navigate to http://localhost:3000/register/client
3. Fill in form with valid data
4. Submit

**Expected:**
- ✅ Redirects to /client/dashboard
- ✅ Shows "Getting Started" section
- ✅ Client navigation visible

### Test 1.4: Role-Based Access Control
**Steps:**
1. Login as mediator
2. Try to access http://localhost:3000/admin/dashboard

**Expected:**
- ✅ Redirects to /login (unauthorized)

**Repeat for:**
- Client trying to access /mediator/*
- Mediator trying to access /client/*
- Public trying to access any protected route

### Test 1.5: Session Persistence
**Steps:**
1. Login as any user
2. Close browser tab
3. Reopen http://localhost:3000/mediator/dashboard

**Expected:**
- ✅ Still logged in (session persists)
- ✅ No redirect to login

### Test 1.6: Logout
**Steps:**
1. Login as any user
2. Click "Logout" in navigation
3. Try to access protected route

**Expected:**
- ✅ Redirects to /login
- ✅ Session cookie deleted
- ✅ Cannot access protected routes

---

## Test Suite 2: Mediator Profile Management

### Test 2.1: View Profile (Incomplete)
**Setup:** Login as newly registered mediator

**Steps:**
1. Navigate to /mediator/profile

**Expected:**
- ✅ Shows profile editor
- ✅ Banner: "Complete Your Profile"
- ✅ No "Submit for Approval" button (profile incomplete)
- ✅ All fields editable
- ✅ GST status displayed (from registration)

### Test 2.2: Edit Basic Information
**Steps:**
1. Click "Edit" on Basic Information section
2. Update:
   - Display Name: "John Smith, Esq."
   - Bio: (minimum 50 characters) "I am a professional mediator with extensive experience in family and commercial disputes. I believe in fostering collaborative solutions."
   - Office Address: "123 Main St, Sydney NSW 2000"
   - Years of Experience: 15
3. Click "Save Changes"

**Expected:**
- ✅ Success message appears
- ✅ Form switches to view mode
- ✅ Updated data displayed
- ✅ Audit log created

### Test 2.3: Edit Specializations
**Steps:**
1. Click "Edit" on Specializations section
2. Select:
   - "Family Mediation"
   - "Divorce Mediation"
   - "Commercial Mediation"
3. Add custom: "International Disputes"
4. Click "Save"

**Expected:**
- ✅ Specializations saved
- ✅ Displayed as tags
- ✅ Custom specialization included
- ✅ At least 1 required (can't save empty)

### Test 2.4: Edit Certifications
**Steps:**
1. Click "Edit" on Certifications
2. Select:
   - "NMAS Accredited Mediator"
   - "Lawyer"
3. Add custom: "Advanced Mediation Certificate"
4. Click "Save"

**Expected:**
- ✅ Certifications saved
- ✅ Displayed as list
- ✅ Custom entry included

### Test 2.5: Edit Languages
**Steps:**
1. Click "Edit" on Languages
2. Select: "English", "Mandarin", "Spanish"
3. Click "Save"

**Expected:**
- ✅ Languages saved
- ✅ Displayed as tags

### Test 2.6: Profile Completeness Check
**After completing all sections above:**

**Expected:**
- ✅ Banner changes to show "Submit for Approval" button
- ✅ Profile marked as complete
- ✅ Can now submit for review

### Test 2.7: Submit for Approval
**Steps:**
1. Click "Submit for Approval" button
2. Confirm action

**Expected:**
- ✅ Status changes to "PENDING_APPROVAL"
- ✅ Banner: "Profile Under Review"
- ✅ Submit button no longer visible
- ✅ Can still edit profile
- ✅ Dashboard updated

### Test 2.8: Cannot Submit Incomplete Profile
**Steps:**
1. Register new mediator
2. Do NOT fill in bio
3. Try to submit for approval

**Expected:**
- ✅ Error: "Profile is incomplete"
- ✅ Lists missing required fields

---

## Test Suite 3: Pricing Configuration

### Test 3.1: View Pricing Page
**Steps:**
1. Login as mediator
2. Navigate to /mediator/profile/pricing

**Expected:**
- ✅ Pricing form displayed
- ✅ GST information banner (based on registration)
- ✅ All fields empty or have defaults
- ✅ Back link to profile

### Test 3.2: Set Basic Pricing
**Steps:**
1. Fill in pricing form:
   - Pre-mediation Fee: 150
   - Hourly Rate: 250
   - Hourly Rate Basis: "Per Party"
   - Minimum Hours: 2
2. Click "Save Pricing"

**Expected:**
- ✅ Success message
- ✅ Data persists
- ✅ Audit log created
- ✅ Pricing appears on public page (when published)

### Test 3.3: Configure Travel Policy
**Steps:**
1. Add to pricing form:
   - Included Kilometers: 50
   - Rate per km: 1.50
2. Save

**Expected:**
- ✅ Travel policy saved
- ✅ Displayed on public page

### Test 3.4: Configure Accommodation
**Steps:**
1. Add:
   - Accommodation Policy: "Accommodation required for locations over 200km from Sydney CBD"
   - Rate: 200
2. Save

**Expected:**
- ✅ Policy saved
- ✅ Rate saved

### Test 3.5: Add Extra Costs Notes
**Steps:**
1. Add to Extra Costs Notes:
   "Additional costs may include printing, venue hire, or interpreter fees as required"
2. Save

**Expected:**
- ✅ Notes saved
- ✅ Displayed on public page

### Test 3.6: Pricing Validation
**Steps:**
1. Try to set hourly rate: -100
2. Try to save

**Expected:**
- ✅ Error: "Hourly rate must be at least $1"
- ✅ Form not submitted

### Test 3.7: GST Display (Registered)
**Setup:** Mediator registered for GST

**Expected:**
- ✅ Banner shows: "displayed as GST-inclusive"
- ✅ Public page shows "(inc GST)" on prices

### Test 3.8: GST Display (Not Registered)
**Setup:** Create mediator without GST registration

**Expected:**
- ✅ Banner shows: "displayed as GST-exclusive"
- ✅ Public page does NOT show "(inc GST)"

---

## Test Suite 4: Admin Approval Workflow

### Test 4.1: View Pending Approvals
**Steps:**
1. Logout
2. Login as admin
3. Navigate to /admin/approvals

**Expected:**
- ✅ Shows all PENDING_APPROVAL mediators
- ✅ Displays complete profile info
- ✅ Shows specializations, certifications
- ✅ Shows pricing if configured
- ✅ If no pending: "No pending approvals" message

### Test 4.2: Approve Mediator
**Steps:**
1. On approval card, add notes: "Profile looks great!"
2. Click "Approve"

**Expected:**
- ✅ Status changes to APPROVED
- ✅ Approval card updated
- ✅ "Publish Profile" button appears
- ✅ Email notification logged (check console)
- ✅ Audit log created
- ✅ Mediator sees "Profile Approved" banner

### Test 4.3: Publish Mediator
**Steps:**
1. Click "Publish Profile" on approved mediator
2. Confirm

**Expected:**
- ✅ Status changes to PUBLISHED
- ✅ Removed from pending queue
- ✅ Appears in /practices directory
- ✅ Practice page accessible
- ✅ Audit log created

### Test 4.4: Reject Mediator
**Setup:** Create another mediator, submit for approval

**Steps:**
1. On approval card, click "Reject"
2. Enter reason: "Please provide more detail in your bio section"
3. Confirm rejection

**Expected:**
- ✅ Status changes to REJECTED
- ✅ Email notification sent (console)
- ✅ Mediator sees rejection banner with reason
- ✅ "Resubmit for Approval" button visible
- ✅ Audit log created

### Test 4.5: Resubmit After Rejection
**Setup:** Login as rejected mediator

**Steps:**
1. Update bio with more detail
2. Click "Resubmit for Approval"

**Expected:**
- ✅ Status changes to PENDING_APPROVAL
- ✅ Appears in admin approval queue again
- ✅ Can be approved/rejected again

### Test 4.6: Cannot Approve Incomplete Profile
**Setup:** Create mediator without complete profile

**Steps:**
1. Try to submit incomplete profile
2. Admin views pending queue

**Expected:**
- ✅ Mediator cannot submit
- ✅ Does not appear in admin queue

### Test 4.7: Suspend Published Mediator
**Setup:** Published mediator

**Steps:**
1. Admin goes to approvals
2. Clicks "Suspend" (if visible on published)
3. Enters reason: "Compliance review"

**Expected:**
- ✅ Status changes to SUSPENDED
- ✅ Removed from /practices
- ✅ Practice page returns 404
- ✅ Mediator cannot access some features

---

## Test Suite 5: Public Practice Pages

### Test 5.1: View Public Directory
**Steps:**
1. Logout (or open incognito)
2. Navigate to http://localhost:3000/practices

**Expected:**
- ✅ Shows all PUBLISHED mediators only
- ✅ Cards display: name, photo, specializations, experience, rate
- ✅ No login required
- ✅ "Get Started" CTA visible
- ✅ Professional layout

### Test 5.2: View Individual Practice Page
**Steps:**
1. Click on a published mediator card
2. View practice page

**Expected:**
- ✅ URL: /practices/[slug]
- ✅ Full profile displayed:
   - Photo (if set)
   - Name and title
   - Specializations
   - Years of experience
   - Bio
   - Certifications
   - Languages
   - Complete pricing breakdown
- ✅ "Request Consultation" CTA
- ✅ Professional design
- ✅ No admin/edit controls visible

### Test 5.3: Public Page Access Control
**Steps:**
1. Try to access practice page for:
   - PENDING_APPROVAL mediator
   - REJECTED mediator
   - Non-existent slug

**Expected:**
- ✅ All return 404 Not Found
- ✅ Only PUBLISHED visible

### Test 5.4: Pricing Display with GST
**Setup:** View published mediator with GST registration

**Expected:**
- ✅ All prices show "(inc GST)"
- ✅ Pricing section clearly labeled

**Setup:** View published mediator without GST registration

**Expected:**
- ✅ Prices do NOT show "(inc GST)"
- ✅ Clean pricing display

### Test 5.5: Empty Directory
**Setup:** No published mediators

**Expected:**
- ✅ Message: "No mediators currently published"
- ✅ Professional empty state

---

## Test Suite 6: Data Integrity & Security

### Test 6.1: Cannot Edit Other's Profile
**Steps:**
1. Login as Mediator A
2. Note Mediator A's ID
3. Logout, login as Mediator B
4. Try to access Mediator A's profile via direct URL manipulation

**Expected:**
- ✅ Cannot view
- ✅ Cannot edit
- ✅ Error or redirect

### Test 6.2: Admin-Only Actions
**Steps:**
1. Login as mediator
2. Try to call admin actions (approve/reject) via browser dev tools

**Expected:**
- ✅ Unauthorized error
- ✅ No database changes

### Test 6.3: SQL Injection Protection
**Steps:**
1. In bio field, enter: `'; DROP TABLE Mediator; --`
2. Save

**Expected:**
- ✅ Saved as plain text
- ✅ No SQL execution
- ✅ Database intact

### Test 6.4: XSS Protection
**Steps:**
1. In bio field, enter: `<script>alert('XSS')</script>`
2. Save
3. View on public page

**Expected:**
- ✅ Rendered as plain text
- ✅ Script not executed
- ✅ Escaped in HTML

### Test 6.5: Audit Log Integrity
**Steps:**
1. Perform any mutation (edit profile, approve, etc.)
2. Open Prisma Studio
3. Check AuditLog table

**Expected:**
- ✅ Entry created
- ✅ Correct user ID
- ✅ Correct action
- ✅ Timestamp accurate
- ✅ Metadata captured

---

## Test Suite 7: Edge Cases & Error Handling

### Test 7.1: Duplicate Specialization
**Steps:**
1. Add "Family Mediation" twice
2. Save

**Expected:**
- ✅ Only one entry saved
- ✅ No duplicates

### Test 7.2: Very Long Bio
**Steps:**
1. Enter bio with 3000 characters
2. Try to save

**Expected:**
- ✅ Error: "Bio must not exceed 2000 characters"
- ✅ Form not submitted

### Test 7.3: Very Short Bio
**Steps:**
1. Enter bio with only 20 characters
2. Try to save

**Expected:**
- ✅ Error: "Bio must be at least 50 characters"
- ✅ Form not submitted

### Test 7.4: Invalid Email Format
**Steps:**
1. During registration, enter: "not-an-email"
2. Submit

**Expected:**
- ✅ Error: "Invalid email address"
- ✅ Form not submitted

### Test 7.5: Session Expiry
**Steps:**
1. Login
2. Wait 7 days (or manually delete session from DB)
3. Try to access protected route

**Expected:**
- ✅ Redirects to login
- ✅ Session expired message

### Test 7.6: Network Error Handling
**Steps:**
1. Open dev tools
2. Go to Network tab
3. Set to "Offline"
4. Try to save profile

**Expected:**
- ✅ Error message shown
- ✅ User-friendly message
- ✅ No data corruption

---

## Test Suite 8: User Experience

### Test 8.1: Form Validation Feedback
**Steps:**
1. Leave required field empty
2. Try to submit

**Expected:**
- ✅ Clear error message
- ✅ Field highlighted
- ✅ Focus on error

### Test 8.2: Success Feedback
**Steps:**
1. Successfully save profile
2. Observe feedback

**Expected:**
- ✅ Success message displays
- ✅ Green/positive color
- ✅ Auto-dismiss after 3 seconds

### Test 8.3: Loading States
**Steps:**
1. Click save on slow connection
2. Observe button state

**Expected:**
- ✅ Button shows "Saving..."
- ✅ Button disabled during save
- ✅ Clear loading indicator

### Test 8.4: Cancel Actions
**Steps:**
1. Click "Edit" on profile section
2. Make changes
3. Click "Cancel"

**Expected:**
- ✅ Changes discarded
- ✅ Returns to view mode
- ✅ Original data displayed

### Test 8.5: Mobile Responsiveness
**Steps:**
1. Open in mobile viewport (DevTools)
2. Navigate through all pages

**Expected:**
- ✅ All pages responsive
- ✅ Forms usable on mobile
- ✅ Navigation accessible
- ✅ No horizontal scroll

---

## Performance Testing

### Test P.1: Page Load Times
**Steps:**
1. Open dev tools Network tab
2. Clear cache
3. Load each page

**Expected:**
- ✅ Initial load < 2 seconds
- ✅ Subsequent loads < 500ms (cached)

### Test P.2: Database Query Performance
**Steps:**
1. Enable Prisma query logging
2. Load /practices
3. Check logs

**Expected:**
- ✅ Efficient queries
- ✅ Proper use of select/include
- ✅ Indexes utilized

---

## Regression Testing Checklist

After any code changes, verify:

- [ ] Authentication still works
- [ ] All dashboards accessible
- [ ] Profile editing saves correctly
- [ ] Admin approvals functional
- [ ] Public pages accessible
- [ ] No TypeScript errors
- [ ] Build completes successfully
- [ ] Tests pass (if applicable)

---

## Bug Reporting Template

When reporting issues:

```
**Environment:**
- OS: [Mac/Windows/Linux]
- Browser: [Chrome/Firefox/Safari]
- Node version: [18.x]
- Database: [PostgreSQL version]

**Steps to Reproduce:**
1. Go to...
2. Click on...
3. Enter...

**Expected Behavior:**
What should happen

**Actual Behavior:**
What actually happens

**Screenshots:**
If applicable

**Console Errors:**
Any errors from browser console

**Additional Context:**
Any other relevant information
```

---

## Quick Test Checklist (5 Minutes)

For rapid verification:

- [ ] Can login as admin
- [ ] Can register as mediator
- [ ] Can edit mediator profile
- [ ] Can set pricing
- [ ] Can submit for approval
- [ ] Admin can approve
- [ ] Admin can publish
- [ ] Profile appears at /practices
- [ ] Practice page loads
- [ ] Can logout

---

**All tests should PASS before deploying to production!**
