import { MediatorProfileService } from '@/modules/mediator/profile/service';
import { ApprovalCard } from '@/components/admin/ApprovalCard';

const profileService = new MediatorProfileService();

export default async function AdminApprovalsPage() {
  const pending = await profileService.getPendingApprovals();

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-900">Mediator Approvals</h1>
        <p className="text-gray-600 mt-2">
          Review and approve mediator applications
        </p>
      </div>

      {pending.length === 0 ? (
        <div className="card text-center py-12">
          <svg className="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
          </svg>
          <p className="text-gray-600">
            No pending approvals
          </p>
        </div>
      ) : (
        <div className="space-y-6">
          {pending.map(mediator => (
            <ApprovalCard key={mediator.id} mediator={mediator} />
          ))}
        </div>
      )}
    </div>
  );
}
