import { prisma } from '@/lib/db';

export default async function AdminDashboardPage() {
  // Get stats
  const [
    totalMediators,
    pendingApprovals,
    activeMediators,
    totalClients,
    totalCases,
  ] = await Promise.all([
    prisma.mediator.count(),
    prisma.mediator.count({ where: { status: 'PENDING_APPROVAL' } }),
    prisma.mediator.count({ where: { status: 'PUBLISHED' } }),
    prisma.client.count(),
    prisma.case.count(),
  ]);

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-900">Admin Dashboard</h1>
        <p className="text-gray-600 mt-2">
          Platform overview and management
        </p>
      </div>

      {/* Stats Grid */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Total Mediators
          </div>
          <div className="text-3xl font-bold text-gray-900">{totalMediators}</div>
          <div className="text-xs text-gray-500 mt-2">
            {activeMediators} active
          </div>
        </div>

        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Pending Approvals
          </div>
          <div className="text-3xl font-bold text-orange-600">{pendingApprovals}</div>
          {pendingApprovals > 0 && (
            <a href="/admin/approvals" className="text-xs text-primary-600 hover:text-primary-700 mt-2 inline-block">
              Review now →
            </a>
          )}
        </div>

        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Total Clients
          </div>
          <div className="text-3xl font-bold text-gray-900">{totalClients}</div>
        </div>

        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Total Cases
          </div>
          <div className="text-3xl font-bold text-gray-900">{totalCases}</div>
        </div>
      </div>

      {/* Quick Actions */}
      <div className="card">
        <h2 className="text-xl font-semibold mb-4">Quick Actions</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
          <a
            href="/admin/approvals"
            className="p-4 border border-gray-200 rounded-lg hover:border-primary-300 hover:bg-primary-50 transition-colors"
          >
            <div className="font-medium text-gray-900 mb-1">Review Mediators</div>
            <div className="text-sm text-gray-600">
              Approve or reject pending mediator applications
            </div>
          </a>

          <a
            href="/admin/audit"
            className="p-4 border border-gray-200 rounded-lg hover:border-primary-300 hover:bg-primary-50 transition-colors"
          >
            <div className="font-medium text-gray-900 mb-1">View Audit Log</div>
            <div className="text-sm text-gray-600">
              Review platform activity and changes
            </div>
          </a>

          <a
            href="/admin/config"
            className="p-4 border border-gray-200 rounded-lg hover:border-primary-300 hover:bg-primary-50 transition-colors"
          >
            <div className="font-medium text-gray-900 mb-1">Platform Settings</div>
            <div className="text-sm text-gray-600">
              Configure fees, trial periods, and more
            </div>
          </a>
        </div>
      </div>
    </div>
  );
}
