import { getCurrentUser } from '@/modules/auth/actions';
import { redirect } from 'next/navigation';
import { HubSpotIntegrationCard } from '@/components/integration/HubSpotIntegrationCard';

export default async function IntegrationsPage() {
  const user = await getCurrentUser();
  
  if (!user || user.role !== 'ADMIN') {
    redirect('/login');
  }

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-900">Integrations</h1>
        <p className="text-gray-600 mt-2">
          Manage third-party integrations
        </p>
      </div>

      {/* HubSpot Integration */}
      <HubSpotIntegrationCard />

      {/* Future integrations can go here */}
      <div className="mt-6 card">
        <h2 className="text-xl font-semibold mb-4">Available Integrations</h2>
        <div className="space-y-3">
          <div className="flex items-center justify-between p-3 border rounded">
            <div>
              <div className="font-medium">Zapier</div>
              <div className="text-sm text-gray-600">Connect to 5000+ apps</div>
            </div>
            <span className="text-sm text-gray-500">Coming soon</span>
          </div>
          
          <div className="flex items-center justify-between p-3 border rounded">
            <div>
              <div className="font-medium">Xero</div>
              <div className="text-sm text-gray-600">Accounting integration</div>
            </div>
            <span className="text-sm text-gray-500">Coming soon</span>
          </div>

          <div className="flex items-center justify-between p-3 border rounded">
            <div>
              <div className="font-medium">Slack</div>
              <div className="text-sm text-gray-600">Team notifications</div>
            </div>
            <span className="text-sm text-gray-500">Coming soon</span>
          </div>
        </div>
      </div>
    </div>
  );
}
