import { getCurrentUser } from '@/modules/auth/actions';
import { redirect } from 'next/navigation';

export default async function ClientDashboardPage() {
  const user = await getCurrentUser();
  
  if (!user?.client) {
    redirect('/login');
  }

  const client = user.client;

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-900">
          Welcome, {client.firstName}!
        </h1>
        <p className="text-gray-600 mt-2">
          Manage your mediation cases and find mediators
        </p>
      </div>

      {/* Quick Stats */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Active Cases
          </div>
          <div className="text-2xl font-bold text-gray-900">0</div>
        </div>

        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Completed Cases
          </div>
          <div className="text-2xl font-bold text-gray-900">0</div>
        </div>

        <div className="card">
          <div className="text-sm font-medium text-gray-600 mb-1">
            Total Spent
          </div>
          <div className="text-2xl font-bold text-gray-900">$0</div>
        </div>
      </div>

      {/* Getting Started */}
      <div className="card">
        <h2 className="text-xl font-semibold mb-4">Getting Started</h2>
        <div className="space-y-4">
          <div className="p-4 border border-gray-200 rounded-lg">
            <div className="flex items-start">
              <div className="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center mr-4">
                <svg className="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                </svg>
              </div>
              <div className="flex-1">
                <h3 className="font-medium text-gray-900 mb-1">Find a Mediator</h3>
                <p className="text-sm text-gray-600 mb-3">
                  Browse our directory of professional mediators specializing in various dispute types
                </p>
                <a href="/mediators" className="text-sm text-primary-600 hover:text-primary-700 font-medium">
                  Browse mediators →
                </a>
              </div>
            </div>
          </div>

          <div className="p-4 border border-gray-200 rounded-lg">
            <div className="flex items-start">
              <div className="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center mr-4">
                <svg className="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
              </div>
              <div className="flex-1">
                <h3 className="font-medium text-gray-900 mb-1">Submit an Inquiry</h3>
                <p className="text-sm text-gray-600 mb-3">
                  Once you find a mediator, you can submit an inquiry to discuss your case
                </p>
                <div className="text-sm text-gray-500">
                  Available in Milestone 4
                </div>
              </div>
            </div>
          </div>

          <div className="p-4 border border-gray-200 rounded-lg">
            <div className="flex items-start">
              <div className="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center mr-4">
                <svg className="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                </svg>
              </div>
              <div className="flex-1">
                <h3 className="font-medium text-gray-900 mb-1">Book & Pay Securely</h3>
                <p className="text-sm text-gray-600 mb-3">
                  Accept quotes, pay deposits, and manage payments through our secure platform
                </p>
                <div className="text-sm text-gray-500">
                  Available in Milestone 5
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
