import { getCurrentUser } from '@/modules/auth/actions';
import { redirect } from 'next/navigation';
import { StripeConnectService } from '@/modules/payment/connect/service';
import { PaymentProcessingService } from '@/modules/payment/processing/service';
import { ConnectOnboardingCard } from '@/components/payment/ConnectOnboardingCard';
import { PaymentStatsCards } from '@/components/payment/PaymentStatsCards';
import { PaymentHistoryTable } from '@/components/payment/PaymentHistoryTable';

const connectService = new StripeConnectService();
const paymentService = new PaymentProcessingService();

export default async function MediatorPaymentsPage() {
  const user = await getCurrentUser();
  
  if (!user?.mediator) {
    redirect('/login');
  }

  const mediator = user.mediator;
  
  // Check Connect status
  let connectStatus = null;
  if (mediator.stripeAccountId) {
    try {
      connectStatus = await connectService.getAccountStatus(mediator.stripeAccountId);
    } catch (error) {
      console.error('Error fetching Connect status:', error);
    }
  }

  // Get payment stats
  const stats = await paymentService.getMediatorPaymentStats(mediator.id);
  
  // Get recent payments
  const payments = await paymentService.getMediatorPayments(mediator.id);

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-900">Payments & Payouts</h1>
        <p className="text-gray-600 mt-2">
          Manage your payment account and view earnings
        </p>
      </div>

      {/* Connect Onboarding */}
      <ConnectOnboardingCard
        mediator={mediator}
        connectStatus={connectStatus}
      />

      {/* Payment Stats */}
      {mediator.stripeOnboarded && (
        <>
          <PaymentStatsCards stats={stats} />
          
          {/* Payment History */}
          <div className="card mt-6">
            <h2 className="text-xl font-semibold mb-4">Payment History</h2>
            <PaymentHistoryTable payments={payments} />
          </div>
        </>
      )}
    </div>
  );
}
