import { getCurrentUser } from '@/modules/auth/actions';
import { redirect } from 'next/navigation';
import { PricingService } from '@/modules/mediator/pricing/service';
import { PricingForm } from '@/components/mediator/PricingForm';
import Link from 'next/link';

const pricingService = new PricingService();

export default async function PricingPage() {
  const user = await getCurrentUser();
  
  if (!user?.mediator) {
    redirect('/login');
  }

  const pricing = await pricingService.getPricing(user.mediator.id);

  return (
    <div className="max-w-4xl mx-auto">
      <div className="mb-8">
        <Link href="/mediator/profile" className="text-sm text-primary-600 hover:text-primary-700 mb-2 inline-block">
          ← Back to Profile
        </Link>
        <h1 className="text-3xl font-bold text-gray-900">Pricing Configuration</h1>
        <p className="text-gray-600 mt-2">
          Set your rates and pricing policies
        </p>
      </div>

      <div className="mb-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
        <div className="flex items-start">
          <svg className="w-5 h-5 text-blue-600 mt-0.5 mr-3" fill="currentColor" viewBox="0 0 20 20">
            <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
          </svg>
          <div className="flex-1 text-sm text-blue-900">
            <strong>GST Information:</strong> {user.mediator.isGstRegistered ? (
              <span>Your pricing will be displayed as GST-inclusive since you are registered for GST.</span>
            ) : (
              <span>Your pricing will be displayed as GST-exclusive since you are not registered for GST.</span>
            )}
          </div>
        </div>
      </div>

      <PricingForm pricing={pricing} isGstRegistered={user.mediator.isGstRegistered} />
    </div>
  );
}
