import Link from 'next/link';
import { loginAction } from '@/modules/auth/actions';

export default function LoginPage() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-md w-full">
        {/* Logo */}
        <div className="text-center mb-8">
          <div className="inline-flex items-center space-x-2 mb-4">
            <div className="w-12 h-12 bg-primary-600 rounded-lg flex items-center justify-center">
              <span className="text-white font-bold text-2xl">M8</span>
            </div>
            <span className="text-3xl font-bold text-gray-900">medi8</span>
          </div>
          <h2 className="text-2xl font-bold text-gray-900">
            Sign in to your account
          </h2>
        </div>

        {/* Login Form */}
        <div className="card">
          <form action={loginAction}>
            <div className="space-y-4">
              <div>
                <label htmlFor="email" className="label">
                  Email address
                </label>
                <input
                  id="email"
                  name="email"
                  type="email"
                  autoComplete="email"
                  required
                  className="input"
                  placeholder="you@example.com"
                />
              </div>

              <div>
                <label htmlFor="password" className="label">
                  Password
                </label>
                <input
                  id="password"
                  name="password"
                  type="password"
                  autoComplete="current-password"
                  required
                  className="input"
                  placeholder="••••••••"
                />
              </div>

              <button
                type="submit"
                className="w-full btn-primary py-3"
              >
                Sign in
              </button>
            </div>
          </form>

          {/* Links */}
          <div className="mt-6 text-center space-y-2">
            <div className="text-sm text-gray-600">
              Don't have an account?
            </div>
            <div className="flex items-center justify-center space-x-4">
              <Link
                href="/register/client"
                className="text-sm text-primary-600 hover:text-primary-700 font-medium"
              >
                Register as Client
              </Link>
              <span className="text-gray-300">|</span>
              <Link
                href="/register/mediator"
                className="text-sm text-primary-600 hover:text-primary-700 font-medium"
              >
                Register as Mediator
              </Link>
            </div>
          </div>
        </div>

        {/* Back to home */}
        <div className="mt-6 text-center">
          <Link href="/" className="text-sm text-gray-600 hover:text-gray-900">
            ← Back to home
          </Link>
        </div>
      </div>
    </div>
  );
}
