import Link from 'next/link';
import { registerMediatorAction } from '@/modules/auth/actions';

export default function RegisterMediatorPage() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-2xl w-full">
        {/* Logo */}
        <div className="text-center mb-8">
          <div className="inline-flex items-center space-x-2 mb-4">
            <div className="w-12 h-12 bg-primary-600 rounded-lg flex items-center justify-center">
              <span className="text-white font-bold text-2xl">M8</span>
            </div>
            <span className="text-3xl font-bold text-gray-900">medi8</span>
          </div>
          <h2 className="text-2xl font-bold text-gray-900">
            Register as Mediator
          </h2>
          <p className="text-sm text-gray-600 mt-2">
            Start your 30-day free trial • No credit card required
          </p>
        </div>

        {/* Registration Form */}
        <div className="card">
          <form action={registerMediatorAction}>
            <div className="space-y-6">
              {/* Personal Information */}
              <div>
                <h3 className="text-lg font-semibold mb-4">Personal Information</h3>
                <div className="space-y-4">
                  <div className="grid grid-cols-2 gap-4">
                    <div>
                      <label htmlFor="firstName" className="label">
                        First name
                      </label>
                      <input
                        id="firstName"
                        name="firstName"
                        type="text"
                        required
                        className="input"
                        placeholder="John"
                      />
                    </div>

                    <div>
                      <label htmlFor="lastName" className="label">
                        Last name
                      </label>
                      <input
                        id="lastName"
                        name="lastName"
                        type="text"
                        required
                        className="input"
                        placeholder="Smith"
                      />
                    </div>
                  </div>

                  <div>
                    <label htmlFor="email" className="label">
                      Email address
                    </label>
                    <input
                      id="email"
                      name="email"
                      type="email"
                      autoComplete="email"
                      required
                      className="input"
                      placeholder="john@example.com"
                    />
                  </div>

                  <div>
                    <label htmlFor="phone" className="label">
                      Phone number (optional)
                    </label>
                    <input
                      id="phone"
                      name="phone"
                      type="tel"
                      className="input"
                      placeholder="+61 4XX XXX XXX"
                    />
                  </div>
                </div>
              </div>

              {/* GST Registration */}
              <div className="border-t pt-6">
                <h3 className="text-lg font-semibold mb-4">GST Registration</h3>
                <div className="space-y-4">
                  <div className="flex items-start">
                    <input
                      id="isGstRegistered"
                      name="isGstRegistered"
                      type="checkbox"
                      value="true"
                      className="mt-1 h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                    />
                    <label htmlFor="isGstRegistered" className="ml-2 text-sm text-gray-700">
                      I am registered for GST
                      <p className="text-xs text-gray-500 mt-1">
                        If you earn more than $75,000/year, you must be registered for GST
                      </p>
                    </label>
                  </div>

                  <div>
                    <label htmlFor="gstNumber" className="label">
                      ABN / GST Number (if applicable)
                    </label>
                    <input
                      id="gstNumber"
                      name="gstNumber"
                      type="text"
                      className="input"
                      placeholder="XX XXX XXX XXX"
                    />
                  </div>
                </div>
              </div>

              {/* Account Security */}
              <div className="border-t pt-6">
                <h3 className="text-lg font-semibold mb-4">Account Security</h3>
                <div>
                  <label htmlFor="password" className="label">
                    Password
                  </label>
                  <input
                    id="password"
                    name="password"
                    type="password"
                    autoComplete="new-password"
                    required
                    className="input"
                    placeholder="••••••••"
                    minLength={6}
                  />
                  <p className="text-xs text-gray-500 mt-1">
                    At least 6 characters
                  </p>
                </div>
              </div>

              {/* Trial Information */}
              <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <div className="flex items-start">
                  <svg className="w-5 h-5 text-blue-600 mt-0.5 mr-3" fill="currentColor" viewBox="0 0 20 20">
                    <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
                  </svg>
                  <div className="text-sm text-blue-900">
                    <strong>30-day free trial included</strong>
                    <p className="mt-1 text-blue-800">
                      Your profile will be reviewed by our team before going live.
                      After your trial, plans start at $55/month (inc GST).
                    </p>
                  </div>
                </div>
              </div>

              <button
                type="submit"
                className="w-full btn-primary py-3"
              >
                Start free trial
              </button>
            </div>
          </form>

          {/* Links */}
          <div className="mt-6 text-center text-sm text-gray-600">
            Already have an account?{' '}
            <Link
              href="/login"
              className="text-primary-600 hover:text-primary-700 font-medium"
            >
              Sign in
            </Link>
          </div>
        </div>

        {/* Back to home */}
        <div className="mt-6 text-center">
          <Link href="/" className="text-sm text-gray-600 hover:text-gray-900">
            ← Back to home
          </Link>
        </div>
      </div>
    </div>
  );
}
