import Link from 'next/link';
import { logoutAction } from '@/modules/auth/actions';
import { UserWithRelations } from '@/modules/auth/types';

interface NavLink {
  href: string;
  label: string;
  icon: React.ReactNode;
}

interface DashboardNavProps {
  user: UserWithRelations;
  links: NavLink[];
}

export function DashboardNav({ user, links }: DashboardNavProps) {
  const displayName = user.mediator
    ? `${user.mediator.firstName} ${user.mediator.lastName}`
    : user.client
    ? `${user.client.firstName} ${user.client.lastName}`
    : user.email;

  return (
    <nav className="bg-white border-b border-gray-200">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between h-16">
          {/* Logo */}
          <div className="flex items-center space-x-8">
            <Link href="/" className="flex items-center space-x-2">
              <div className="w-8 h-8 bg-primary-600 rounded-lg flex items-center justify-center">
                <span className="text-white font-bold">M8</span>
              </div>
              <span className="text-xl font-bold text-gray-900">medi8</span>
            </Link>

            {/* Nav Links */}
            <div className="hidden md:flex items-center space-x-1">
              {links.map((link) => (
                <Link
                  key={link.href}
                  href={link.href}
                  className="px-3 py-2 rounded-lg text-sm font-medium text-gray-700 hover:bg-gray-100 hover:text-gray-900 transition-colors flex items-center space-x-2"
                >
                  {link.icon}
                  <span>{link.label}</span>
                </Link>
              ))}
            </div>
          </div>

          {/* User Menu */}
          <div className="flex items-center space-x-4">
            <div className="text-sm text-gray-700">
              <div className="font-medium">{displayName}</div>
              <div className="text-xs text-gray-500">{user.role}</div>
            </div>
            
            <form action={logoutAction}>
              <button
                type="submit"
                className="text-sm text-gray-600 hover:text-gray-900"
              >
                Logout
              </button>
            </form>
          </div>
        </div>
      </div>
    </nav>
  );
}
