'use client';

import { useState } from 'react';
import { acknowledgeDocumentAction } from '@/modules/document/actions';

interface AcknowledgeButtonProps {
  sentId: string;
  clientId: string;
}

export function AcknowledgeButton({ sentId, clientId }: AcknowledgeButtonProps) {
  const [isAcknowledging, setIsAcknowledging] = useState(false);
  const [acknowledged, setAcknowledged] = useState(false);
  const [error, setError] = useState<string | null>(null);

  const handleAcknowledge = async () => {
    setIsAcknowledging(true);
    setError(null);

    const result = await acknowledgeDocumentAction(sentId);

    if (result.error) {
      setError(result.error);
    } else {
      setAcknowledged(true);
    }

    setIsAcknowledging(false);
  };

  if (acknowledged) {
    return (
      <div className="bg-green-50 border border-green-200 rounded-lg p-6">
        <div className="flex items-center">
          <svg className="w-6 h-6 text-green-600 mr-3" fill="currentColor" viewBox="0 0 20 20">
            <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
          </svg>
          <div>
            <h3 className="text-lg font-semibold text-green-900">
              Thank You!
            </h3>
            <p className="text-green-800">
              Your acknowledgement has been recorded.
            </p>
          </div>
        </div>
      </div>
    );
  }

  return (
    <div>
      {error && (
        <div className="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg text-sm text-red-800">
          {error}
        </div>
      )}

      <button
        onClick={handleAcknowledge}
        disabled={isAcknowledging}
        className="w-full btn-primary py-3 text-lg"
      >
        {isAcknowledging ? 'Processing...' : 'I Acknowledge'}
      </button>

      <p className="text-xs text-gray-500 text-center mt-4">
        Acknowledged on {new Date().toLocaleDateString()} at {new Date().toLocaleTimeString()}
      </p>
    </div>
  );
}
