'use client';

interface PaymentStats {
  totalPayments: number;
  totalEarnings: number;
  totalProcessed: number;
  totalPlatformFees: number;
  averagePayment: number;
}

export function PaymentStatsCards({ stats }: { stats: PaymentStats }) {
  return (
    <div className="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
      <div className="card">
        <div className="text-sm font-medium text-gray-600 mb-1">Total Earnings</div>
        <div className="text-3xl font-bold text-green-600">
          ${stats.totalEarnings.toFixed(2)}
        </div>
        <div className="text-xs text-gray-500 mt-1">
          After platform fees
        </div>
      </div>

      <div className="card">
        <div className="text-sm font-medium text-gray-600 mb-1">Total Processed</div>
        <div className="text-3xl font-bold text-gray-900">
          ${stats.totalProcessed.toFixed(2)}
        </div>
        <div className="text-xs text-gray-500 mt-1">
          From {stats.totalPayments} payments
        </div>
      </div>

      <div className="card">
        <div className="text-sm font-medium text-gray-600 mb-1">Platform Fees</div>
        <div className="text-3xl font-bold text-gray-900">
          ${stats.totalPlatformFees.toFixed(2)}
        </div>
        <div className="text-xs text-gray-500 mt-1">
          ~10% of net
        </div>
      </div>

      <div className="card">
        <div className="text-sm font-medium text-gray-600 mb-1">Average Payment</div>
        <div className="text-3xl font-bold text-gray-900">
          ${stats.averagePayment.toFixed(2)}
        </div>
        <div className="text-xs text-gray-500 mt-1">
          Per transaction
        </div>
      </div>
    </div>
  );
}

export function PaymentHistoryTable({ payments }: { payments: any[] }) {
  if (payments.length === 0) {
    return (
      <div className="text-center py-8 text-gray-500">
        No payments yet
      </div>
    );
  }

  return (
    <div className="overflow-x-auto">
      <table className="w-full">
        <thead className="bg-gray-50 border-b">
          <tr>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Case</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Client</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Your Earnings</th>
            <th className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
          </tr>
        </thead>
        <tbody className="divide-y divide-gray-200">
          {payments.map((payment) => (
            <tr key={payment.id} className="hover:bg-gray-50">
              <td className="px-4 py-3 text-sm text-gray-900">
                {new Date(payment.createdAt).toLocaleDateString()}
              </td>
              <td className="px-4 py-3 text-sm text-gray-900">
                {payment.case.caseNumber}
              </td>
              <td className="px-4 py-3 text-sm text-gray-600">
                {payment.client.firstName} {payment.client.lastName}
              </td>
              <td className="px-4 py-3 text-sm">
                <span className={`px-2 py-1 rounded text-xs font-medium ${
                  payment.type === 'DEPOSIT' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800'
                }`}>
                  {payment.type}
                </span>
              </td>
              <td className="px-4 py-3 text-sm text-gray-900">
                ${payment.stripeGrossAmount.toString()}
              </td>
              <td className="px-4 py-3 text-sm font-medium text-green-600">
                ${payment.mediatorAmount.toString()}
              </td>
              <td className="px-4 py-3 text-sm">
                <span className={`px-2 py-1 rounded text-xs font-medium ${
                  payment.status === 'SUCCEEDED' ? 'bg-green-100 text-green-800' :
                  payment.status === 'PENDING' ? 'bg-yellow-100 text-yellow-800' :
                  'bg-red-100 text-red-800'
                }`}>
                  {payment.status}
                </span>
              </td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
