import Stripe from 'stripe';

if (!process.env.STRIPE_SECRET_KEY) {
  throw new Error('STRIPE_SECRET_KEY is not set in environment variables');
}

export const stripe = new Stripe(process.env.STRIPE_SECRET_KEY, {
  apiVersion: '2024-11-20.acacia',
  typescript: true,
});

// Platform configuration
export const STRIPE_CONFIG = {
  // Deposit amount (platform keeps 100%)
  DEPOSIT_AMOUNT: 25000, // $250 in cents
  
  // Platform fee percentage (applied to balance payments)
  PLATFORM_FEE_PERCENT: 0.10, // 10%
  
  // Stripe fee estimation
  STRIPE_FEE_PERCENT: 0.029, // 2.9%
  STRIPE_FEE_FIXED: 30, // $0.30 in cents
  
  // Currency
  CURRENCY: 'aud',
  
  // Connect account type
  CONNECT_ACCOUNT_TYPE: 'express' as const,
  
  // Return URLs for Connect onboarding
  getConnectReturnUrl: (mediatorId: string) => {
    const baseUrl = process.env.APP_URL || 'http://localhost:3000';
    return `${baseUrl}/mediator/payments/connect/return?mediatorId=${mediatorId}`;
  },
  
  getConnectRefreshUrl: (mediatorId: string) => {
    const baseUrl = process.env.APP_URL || 'http://localhost:3000';
    return `${baseUrl}/mediator/payments/connect/refresh?mediatorId=${mediatorId}`;
  },
};

export function getPublishableKey(): string {
  return process.env.STRIPE_PUBLISHABLE_KEY || '';
}
