import { User, Mediator, Client, UserRole } from '@prisma/client';

export type UserWithRelations = User & {
  mediator?: Mediator | null;
  client?: Client | null;
};

export interface SessionUser extends UserWithRelations {
  sessionToken: string;
}

export interface AuthResult {
  user: UserWithRelations;
  sessionToken: string;
}
