import { z } from 'zod';
import { HourlyRateBasis } from '@prisma/client';

export const pricingSchema = z.object({
  preMediationFee: z.number().min(0, 'Pre-mediation fee must be positive').optional(),
  hourlyRate: z.number().min(1, 'Hourly rate must be at least $1').max(10000, 'Hourly rate seems too high'),
  hourlyRateBasis: z.nativeEnum(HourlyRateBasis),
  minimumHours: z.number().min(0).max(100).optional(),
  travelIncludedKm: z.number().min(0).max(1000).optional(),
  travelRatePerKm: z.number().min(0).max(100).optional(),
  accommodationPolicy: z.string().max(500).optional(),
  accommodationRate: z.number().min(0).max(10000).optional(),
  extraCostsNotes: z.string().max(1000).optional(),
});

export type PricingInput = z.infer<typeof pricingSchema>;
