import { z } from 'zod';

export const updateProfileSchema = z.object({
  firstName: z.string().min(1, 'First name is required').optional(),
  lastName: z.string().min(1, 'Last name is required').optional(),
  displayName: z.string().optional(),
  bio: z.string().min(50, 'Bio must be at least 50 characters').max(2000, 'Bio must not exceed 2000 characters').optional(),
  phone: z.string().min(1, 'Phone is required').optional(),
  officeAddress: z.string().optional(),
  yearsExperience: z.number().min(0, 'Years of experience must be positive').max(70, 'Years of experience seems too high').optional(),
});

export const specializationsSchema = z.object({
  specializations: z.array(z.string()).min(1, 'At least one specialization is required'),
});

export const certificationsSchema = z.object({
  certifications: z.array(z.string()),
});

export const languagesSchema = z.object({
  languages: z.array(z.string()),
});

// Common specializations
export const COMMON_SPECIALIZATIONS = [
  'Family Mediation',
  'Divorce Mediation',
  'Workplace Mediation',
  'Commercial Mediation',
  'Property Disputes',
  'Neighbourhood Disputes',
  'Elder Mediation',
  'Estate Disputes',
  'Business Partnership Disputes',
  'Consumer Disputes',
  'Community Mediation',
  'Online Dispute Resolution',
] as const;

// Common certifications
export const COMMON_CERTIFICATIONS = [
  'NMAS Accredited Mediator',
  'FDR Practitioner',
  'Lawyer',
  'Family Therapist',
  'Psychologist',
  'AIFLAM Member',
  'LEADR Member',
  'MSB Accredited',
] as const;

// Common languages
export const COMMON_LANGUAGES = [
  'English',
  'Mandarin',
  'Cantonese',
  'Arabic',
  'Vietnamese',
  'Italian',
  'Greek',
  'Spanish',
  'Hindi',
  'Punjabi',
  'Korean',
  'Tagalog',
] as const;

export type UpdateProfileInput = z.infer<typeof updateProfileSchema>;
export type SpecializationsInput = z.infer<typeof specializationsSchema>;
export type CertificationsInput = z.infer<typeof certificationsSchema>;
export type LanguagesInput = z.infer<typeof languagesSchema>;
